"use client";
import { Montserrat, Nunito } from "next/font/google";
import { Toaster } from "react-hot-toast";
import { Providers } from "../redux/providers";
import { Suspense } from "react";
import "./globals.css";
import ScrollToTopButton from "./components/ScrollToTop/ScrollToTopButton";
import ProtectedRoutes from "@/utils/ProtectedRoutes";
import { usePathname } from "next/navigation";
import SessionWatcher from "@/utils/SessionWatcher";

const montserrat = Montserrat({
  weight: ["300", "400", "500", "600", "700", "800"],
  subsets: ["latin"],
  variable: "--font-montserrat",
});

const nunito = Nunito({
  weight: ["300", "400", "500", "600", "700", "800"],
  subsets: ["latin"],
  variable: "--font-nunito",
});

export default function RootLayout({ children }) {
  const pathname = usePathname();
  const title =
    pathname === "/coming-soon"
      ? "Agent Ambition Academy - Coming Soon"
      : "Agent Ambition Academy";

  return (
    <html lang="en">
      <head>
        <meta name="title" content="Pay4" />
        <meta name="description" content="Generated by create next app" />
        <meta
          name="google-site-verification"
          content="AzlrZvfsfQu9OuksV9litxWXCg5hdKOkccWuyD0ia4w"
        />
        <title>{title}</title>
      </head>
      <body className={`${montserrat.variable} ${nunito.variable}`}>
        <Providers>
          <Suspense>
            <Toaster />
            <ProtectedRoutes>{children}</ProtectedRoutes>
            <ScrollToTopButton />
            <SessionWatcher />
          </Suspense>
        </Providers>
      </body>
    </html>
  );
}
